
//sValidation=nyfjs
//sCaption=Import files as child items ...
//sHint=Import local files as child items, text files as notes, else as attachments
//sCategory=MainMenu.Capture
//sLocaleID=p.ImportFilesAsChild
//sAppVerMin=6.0
//sShortcutKey=

//2011.8.20 enhancements:
//1. detect and change the obsolete RTF control word 'chcbpat' to 'highlight';
//	It helps import those unqualified RTF text generated by bad programs.
//2. For HTML documents, accompanying graphics (if any) will be imported smartly.
//	If any accompanying graphics imported, the webpage may be altered to apply relative path.
//	The HTML document is supposed to be encoded in either UTF-8 or ANSI.
//	If it's in UCS2 BE/LE, it may have problems applying relative path. ie. UCS2 not supported by now.


//2010.6.6 Extension names for text files (*customizable*);
var sTxtExts='.rtf;.txt';
var sHtmExts='.html;.htm';

var _lc=function(sTag, sDef){return plugin.getLocaleMsg(sTag, sDef);};
var _lc2=function(sTag, sDef){return _lc(plugin.getLocaleID()+'.'+sTag, sDef);};

var xNyf=new CNyfDb(-1);

if(xNyf.isOpen()){

	if(!xNyf.isReadonly(-1)){

		var vFiles=platform.getOpenFileName(
			{ sTitle: ''
			, sFilter: 'All files (*.*)|*.*|HTML documents (*.htm;*.html)|*.htm;*.html|Text file (*.rtf;*.txt)|*.rtf;*.txt'
			, bMultiSelect: true
			, bHideReadonly: true
			});

		if(vFiles && vFiles.length>0){

			plugin.initProgressRange(plugin.getScriptTitle());

			var sCurItem=plugin.getCurInfoItem(-1), nDone=0;

			if(!sCurItem) sCurItem=plugin.getDefRootContainer();

			var _find_unique_id=function(sSsgPath){
				return xNyf.getChildEntry(sSsgPath, 0);
			};

			var _fix_bad_controlwords=function(s)
			{
				//2011.8.19 alter the obsolete word '\chcbpat#' to '\highlight#';
				return (s||'').replace(/(\\chcbpat)(\d+)/g, '\\highlight$2');
			}

			var _is_htm_utf8=function(s){
				return (s||'').match(/content=\"text\/html;\s+charset=utf-8\"/i)!=null;
			};

			var _is_local_obj=function(s){
				//return !(s.match(/^javascript:/i) || s.match(/^mailto:/i) || s.match(/:\/\//i));
				//2011.12.3 test if it's javascript, mailto, http://, or contains any of :?#;
				return s.match(/^javascript:/i)==null && s.match(/^mailto:/i)==null && s.match(/:\/\//i)==null && s.match(/[:\?\#]/i)==null;
			};

			var _detect_linked_objs=function(s, sTag, vObjs){
				if(s && sTag){
					//2011.8.20 '\s' seems not to function within the [...] operator, so replace it with ' \t';

					/*
					//2012.7.30 this code doesn't work with filnames having spaces, like this,
					//<img src="./abc def ghi/1.jpg" align="Bottom" ...>
					var re=new RegExp(sTag+'=[\"\']?(.+?)[\"\']?[> \t]', 'ig'), v=[];
					while(v=re.exec(s)){
						if(v && v.length>1){
							//2011.8.21 in case of empty filenames which would cause problems, like this: herf="" or src='';
							var sObj=v[1].replace(/[\'\"]/g, '');
							if(sObj && _is_local_obj(sObj)){
								if(vObjs.indexOf(sObj)<0){
									vObjs[vObjs.length]=sObj;
								}
							}
						}
					}
					*/

					//2012.7.30 consider all 3 possible formats of the linked objects;
					var vRE=[
						  '=\"(.+?)\"'				//src="abc def.jpg"
						, '=\'(.+?)\''				//src='abc def.jpg'
						, '=(?!\"|\')(.+?)[> \t]'	//src=abc.jpg, spaces not allowed;
					];
					for(var i in vRE){
						var re=new RegExp(sTag+vRE[i], 'ig'), v=[];
						while(v=re.exec(s)){
							if(v && v.length>1){
								//2011.8.21 in case of empty filenames which would cause problems, like this: herf="" or src='';
								var sObj=v[1].replace(/[\'\"]/g, '');
								if(sObj && _is_local_obj(sObj)){
									if(vObjs.indexOf(sObj)<0){
										vObjs[vObjs.length]=sObj;
									}
								}
							}
						}
					}
				}
			};

			for(var i in vFiles){
				var xFn=new CLocalFile(vFiles[i]);
				var sExt=xFn.getExtension().toLowerCase(), sFileName=xFn.getLeafName(), sTitle=xFn.getTitle(), sDir=xFn.getDirectory();
				var bRtf=(sExt=='.rtf');
				var bTxt=sTxtExts.split(';').indexOf(sExt)>=0;
				var bHtm=sHtmExts.split(';').indexOf(sExt)>=0;

				var bContinue=plugin.ctrlProgressBar(sFileName, 1, true);
				if(!bContinue) break;

				var xChild=new CLocalFile(sCurItem); xChild.append(_find_unique_id(sCurItem));

				//2011.8.19 attempts to filter out some known obsolete control words;
				if(bRtf){
					var sRtf=xFn.loadText();
					var sNew=_fix_bad_controlwords(sRtf);
					if(sRtf!=sNew){
						var xTmpFn=new CLocalFile(platform.getTempFile('', '', '.tmp')); platform.deferDeleteFile(xTmpFn);
						xTmpFn.saveAnsi(sNew);
						xFn=xTmpFn;
					}
				}else if(bHtm){
					var sHtm=xFn.loadText(), bUtf8=xFn.typeOfEncoding()=='UTF8';

					//2011.8.20 detect linked images/links and then redirect them to local items;
					var vObjs=[];
					_detect_linked_objs(sHtm, 'src', vObjs);
					_detect_linked_objs(sHtm, 'href', vObjs);

					var sNew=sHtm;
					for(var i in vObjs){
						var sObj=vObjs[i];
						if(_is_local_obj(sObj)){
							var f=new CLocalFile(sObj), sObjLeaf=f.getLeafName(), sExt=f.getExtension()||'';

							//2011.12.3 exclude the linked .html files
							if(sObjLeaf && sExt.match(/(htm|php)/i)==null){
								var xSsg=new CLocalFile(''+xChild); xSsg.append(sObjLeaf);
								var xObj=new CLocalFile(sDir); xObj.append(sObj);
								if(xObj.exists()){
									if(xNyf.createFile(xSsg, xObj)>0){
										var sPat=sObj.replace(/([\.\/\\\!])/ig, '\\$1');
										sNew=sNew.replace(new RegExp(sPat, 'ig'), sObjLeaf);
									}
								}
							}
						}
					}

					if(sHtm!=sNew){
						var xTmpFn=new CLocalFile(platform.getTempFile('', '', '.tmp')); platform.deferDeleteFile(xTmpFn);
						if(bUtf8){
							xTmpFn.saveUtf8(sNew);
						}else{
							xTmpFn.saveAnsi(sNew);
						}
						xFn=xTmpFn;
					}
				}

				if(xNyf.createFolder(xChild)){
					xNyf.setFolderHint(xChild, sTitle||'untitled');
					var xSsgFn=new CLocalFile(xChild); xSsgFn.append(bTxt ? plugin.getDefNoteFn() : sFileName);
					var nBytes=xNyf.createFile(xSsgFn, xFn);
					if(nBytes>=0){
						nDone++;
					}else{
						if(!confirm(_lc2('Fail.GoAnyway', 'Failed to import the file. Continue anyway?')+'\n\n'+sFn)){
							break;
						}
					}
				}
			}

			if(nDone>0){
				plugin.refreshOutline(-1, sCurItem);
				var sMsg=_lc2('Done', 'Total %nCount% child item(s) successfully inserted.');
				sMsg=sMsg.replace(/%nCount%/gi, ''+nDone);
				alert(sMsg);
			}

		}

	}else{
		alert(_lc('Prompt.Warn.ReadonlyDb', 'Cannot modify the database opened as Readonly.'));
	}

}else{
	alert(_lc('Prompt.Warn.NoDbOpened', 'No database is currently opened.'));
}
